import type { Metadata } from "next";
import { Geist, Geist_Mono, Pacifico } from "next/font/google";
import "./globals.css";

const pacifico = Pacifico({
  weight: '400',
  subsets: ['latin'],
  display: 'swap',
  variable: '--font-pacifico',
})

const geistSans = Geist({
  variable: "--font-geist-sans",
  subsets: ["latin"],
});

const geistMono = Geist_Mono({
  variable: "--font-geist-mono",
  subsets: ["latin"],
});

export const metadata: Metadata = {
  title: "Çartes Tesisat - Niğde Sıhhi Tesisat ve Su Tesisatçısı | 7/24 Acil Hizmet",
  description: "Niğde'de sıhhi tesisat, su kaçak tespiti, petek temizliği, acil tesisatçı hizmetleri. Niğde tesisatçı, kalorifer tesisatı, musluk tamiri. 7/24 acil müdahale. Çartes Tesisat ile güvenilir çözüm.",
  keywords: "Niğde sıhhi tesisat, Niğde tesisatçı, su tesisatçısı Niğde, acil tesisatçı Niğde, kalorifer tesisatı, petek temizleme, su kaçağı tespiti, musluk tamiri Niğde, Çartes Tesisat",
  robots: "index, follow",
  openGraph: {
    title: "Çartes Tesisat - Niğde Sıhhi Tesisat ve Su Tesisatçısı",
    description: "Niğde'de sıhhi tesisat, su kaçak tespiti, petek temizliği, acil tesisatçı hizmetleri. 7/24 acil müdahale.",
    type: "website",
    locale: "tr_TR",
  },
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="tr" suppressHydrationWarning={true}>
      <head>
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <meta name="author" content="Çartes Tesisat" />
        <meta name="geo.region" content="TR-51" />
        <meta name="geo.placename" content="Niğde" />
        <meta name="geo.position" content="37.9667;34.6833" />
        <meta name="ICBM" content="37.9667, 34.6833" />
        <link rel="canonical" href="https://cartestesisat.com" />
        <script type="application/ld+json">
          {JSON.stringify({
            "@context": "https://schema.org",
            "@type": "LocalBusiness",
            "name": "Çartes Tesisat",
            "description": "Niğde'de sıhhi tesisat, su kaçak tespiti, petek temizliği ve acil tesisatçı hizmetleri",
            "url": "https://cartestesisat.com",
            "telephone": "+905551234567",
            "email": "info@cartestesisat.com",
            "address": {
              "@type": "PostalAddress",
              "streetAddress": "Niğde Merkez",
              "addressLocality": "Niğde",
              "addressRegion": "Niğde",
              "postalCode": "51100",
              "addressCountry": "TR"
            },
            "geo": {
              "@type": "GeoCoordinates",
              "latitude": 37.9667,
              "longitude": 34.6833
            },
            "openingHours": "Mo-Su 00:00-23:59",
            "priceRange": "$$",
            "serviceArea": {
              "@type": "City",
              "name": "Niğde"
            }
          })}
        </script>
      </head>
      <body
        className={`${geistSans.variable} ${geistMono.variable} ${pacifico.variable} antialiased`}
      >
        {children}
      </body>
    </html>
  );
}
